# -*- coding: utf-8 -*-
"""
Created on Thu Sep 30 16:48:03 2021

@author: perlita
@title: project 3
"""

import math
import matplotlib.pyplot as plt

import scipy as sp
import scipy . stats

def f(x):
    
    e = math.e
    pi = math.pi
    sqr = math.sqrt(2*pi)
    xsqr = x**2
    
    return (1/sqr)*e**(-(xsqr/2))

def midpoint(f, a, b):
    
    n = 1000000
    h = (b-a)/n
    s = 0
    
    for i in range(n):
        
        s = s + (f(a+(i*h)+(h/2)))*h
    
    return s

def trapazoid(f, a, b):
    
    n = 1000000
    h = (b-a)/n
    s = 0
    
    for i in range(n):
        
        s = s + ((f(a+(i*h))+f(a+(i+1)*h))/2)*h
    
    return s

def simpson(f, a, b):
    
    n = 1000000
    h = (b-a)/n
    s = 0
    
    for i in range(n):
        
        s = s + (h/3)*(f(a+(i+1)*h)+(4*f(a+h))+f(b+(i*h)))
    
    return s

a = 2
b = -2

test_midpoint = midpoint(f, a, b)
test_trapazoid = trapazoid(f, a, b)
test_simpson = simpson(f, a, b)

print('Midpoint:')
print(test_midpoint)
print('Trapazoid: ')
print(test_trapazoid)
print('Simpson:')
print(test_simpson)

A = sp . stats . norm . cdf (2 ) - sp . stats . norm . cdf (-2)
print()
print('Answer:')
print(A)

midpoint_error = abs(A - test_midpoint)
trapazoid_error = abs(A - test_trapazoid)
simpson_error = abs(A - test_simpson)


rel_erros = [midpoint_error, trapazoid_error, simpson_error]

plt.loglog(rel_erros)
plt.title('Relative Error of Integral')

# Note: I looked up the simpson method both online and in 
#  the textbook and I'm not quite sure I understood it
#  properly nor do I think I translated it into code 
#  properly. I think I might be leaving something out as
#  the simpson answer is sort of close to the other methods,
#  but I still don't know what I could be missing or what
#  I need to change. Feedback on this would be totally 
#  welcomed!

